﻿using System;
using System.Net.Http;
using System.Net.Http.Json;
using System.Threading.Tasks;
using System.Collections.Generic;
using MyFirstApp.Shared;

namespace MyFirstApp.Client.Services
{
    public class UserService
    {
        private readonly HttpClient _httpClient;
        public UserService(HttpClient httpClient)
        {
            _httpClient = httpClient;
        }

        public async Task<IEnumerable<User>> GetUsersAsync()
        {
            IEnumerable<User> users = new List<User>();
            try
            {
                users = await _httpClient.GetFromJsonAsync<User[]>("User");
            }
            catch (Exception exception)
            {
                Console.WriteLine($"Exception in get operation {exception.Message}");
            }

            return users;
        }

        public async Task Update(User user)
        {
            try
            {
                await _httpClient.PutAsJsonAsync($"/{user.Id}", user);
            }
            catch (Exception exception)
            {
                Console.WriteLine("Exception in update operation" + exception.Message);
            }
        }

        public async Task<string> Delete(string id)
        {
            string result = string.Empty;
            try
            {
                var resultRequest = await _httpClient.DeleteAsync("/" + id);
                result = resultRequest.Content.ReadAsStringAsync().Result;
            }
            catch (Exception exception)
            {
                Console.WriteLine("Exception in delete operation " + exception.Message);
            }

            return result;
        }
    }
}
